# Переменные
Переменные можно представить как именованные контейнеры, которые могут содержать некое значение.
Оператор `=` используется для объявления переменной и сохранения в ней значения.

`variable_name = value`

Левая часть оператора — это имя переменной. Ты можешь дать ей любое имя, какое захочешь.
Правая часть — это выражение, значение которого будет сохранено в переменной.

Объявим переменную с именем `a` и сохраним в ней значение `5`:
`a = 5`
Объявим переменную с именем `b` и сохраним в ней возвращаемое значение `can_harvest()`:
`b = can_harvest()`

Не путай оператор `=` с оператором `==`.
Оператор `==` проверяет, равны ли два значения, и возвращает `True` или `False`.
Оператор `=` присваивает значение справа имени слева.

После того как переменной присвоено значение, ты можешь использовать ее в коде для получения содержащегося в ней значения:

`a = 5
for i in range(a):
	do_a_flip()`

Приведенный выше цикл выполняется 5 раз, потому что для `a` задано значение `5`.
`i` в цикле `for` тоже переменная, которой автоматически присваивается текущее значение последовательности на каждой итерации цикла. (Ее необязательно называть `i`, ты можешь дать ей любое допустимое имя переменной.)

Переменные позволяют делать то же самое и с циклом `while`:

`a = 5
i = 0
while i < a:
	do_a_flip()
	i = i + 1`

Результат будет тот же, что и у цикла `for` выше. Нам просто нужно увеличивать `i` вручную.
Обрати внимание, что для увеличения переменной i, мы задаем ее равной ее собственному значению плюс `1`. Изменение значения переменной на основе ее предыдущего значения широко применяется в программировании.
Код можно сократить, используя следующие операторы: `+=, -=, *=, /=, %=`.

`i = i + 1` означает то же самое, что и `i += 1`.
`a = a / 3` — то же самое, что и `a /= 3`.
